var acornLoose = require('acorn-loose');
var acorn = require("acorn");

var fname_data = {
  "WebGLShader": true,
  "WebGLShaderPrecisionFormat": true,
  "WebGLQuery": true,
  "WebGLRenderbuffer": true,
  "WebGLSampler": true,
  "WebGLUniformLocation": true,
  "WebGLFramebuffer": true,
  "WebGLProgram": true,
  "WebGLContextEvent": true,
  "WebGL2RenderingContext": true,
  "WebGLTexture": true,
  "WebGLRenderingContext": true,
  "WebGLVertexArrayObject": true,
  "WebGLActiveInfo": true,
  "WebGLTransformFeedback": true,
  "WebGLSync": true,
  "WebGLBuffer": true,
  "cat_svg": true,
  "SVGPoint": true,
  "SVGEllipseElement": true,
  "SVGRadialGradientElement": true,
  "SVGComponentTransferFunctionElement": true,
  "SVGPathSegCurvetoQuadraticAbs": true,
  "SVGAnimatedNumberList": true,
  "SVGPathSegCurvetoQuadraticSmoothRel": true,
  "SVGFEColorMatrixElement": true,
  "SVGPathSegLinetoHorizontalAbs": true,
  "SVGLinearGradientElement": true,
  "SVGStyleElement": true,
  "SVGPathSegMovetoRel": true,
  "SVGStopElement": true,
  "SVGPathSegLinetoRel": true,
  "SVGFEConvolveMatrixElement": true,
  "SVGAnimatedAngle": true,
  "SVGPathSegLinetoAbs": true,
  "SVGPreserveAspectRatio": true,
  "SVGFEOffsetElement": true,
  "SVGFEImageElement": true,
  "SVGFEDiffuseLightingElement": true,
  "SVGAnimatedNumber": true,
  "SVGTextElement": true,
  "SVGFESpotLightElement": true,
  "SVGFEMorphologyElement": true,
  "SVGAngle": true,
  "SVGScriptElement": true,
  "SVGFEDropShadowElement": true,
  "SVGPathSegArcRel": true,
  "SVGNumber": true,
  "SVGPathSegLinetoHorizontalRel": true,
  "SVGFEFuncBElement": true,
  "SVGClipPathElement": true,
  "SVGPathSeg": true,
  "SVGUseElement": true,
  "SVGPathSegArcAbs": true,
  "SVGPathSegCurvetoQuadraticSmoothAbs": true,
  "SVGRect": true,
  "SVGAnimatedPreserveAspectRatio": true,
  "SVGImageElement": true,
  "SVGAnimatedEnumeration": true,
  "SVGAnimatedLengthList": true,
  "SVGFEFloodElement": true,
  "SVGFECompositeElement": true,
  "SVGAElement": true,
  "SVGAnimatedBoolean": true,
  "SVGMaskElement": true,
  "SVGFilterElement": true,
  "SVGPathSegLinetoVerticalRel": true,
  "SVGAnimatedInteger": true,
  "SVGTSpanElement": true,
  "SVGMarkerElement": true,
  "SVGStringList": true,
  "SVGTransform": true,
  "SVGTitleElement": true,
  "SVGFEBlendElement": true,
  "SVGTextPositioningElement": true,
  "SVGFEFuncGElement": true,
  "SVGFEPointLightElement": true,
  "SVGAnimateElement": true,
  "SVGPolylineElement": true,
  "SVGDefsElement": true,
  "SVGPathSegList": true,
  "SVGAnimatedTransformList": true,
  "SVGPathSegClosePath": true,
  "SVGGradientElement": true,
  "SVGSwitchElement": true,
  "SVGViewElement": true,
  "SVGUnitTypes": true,
  "SVGPathSegMovetoAbs": true,
  "SVGSymbolElement": true,
  "SVGFEFuncAElement": true,
  "SVGAnimatedString": true,
  "SVGFEMergeElement": true,
  "SVGPathSegLinetoVerticalAbs": true,
  "SVGAnimationElement": true,
  "SVGPathSegCurvetoCubicAbs": true,
  "SVGLength": true,
  "SVGTextPathElement": true,
  "SVGPolygonElement": true,
  "SVGAnimatedRect": true,
  "SVGPathSegCurvetoCubicRel": true,
  "SVGFEFuncRElement": true,
  "SVGLengthList": true,
  "SVGTextContentElement": true,
  "SVGFETurbulenceElement": true,
  "SVGMatrix": true,
  "SVGZoomAndPan": true,
  "SVGMetadataElement": true,
  "SVGFEDistantLightElement": true,
  "SVGAnimateMotionElement": true,
  "SVGDescElement": true,
  "SVGPathSegCurvetoCubicSmoothRel": true,
  "SVGFESpecularLightingElement": true,
  "SVGFEGaussianBlurElement": true,
  "SVGFEComponentTransferElement": true,
  "SVGNumberList": true,
  "SVGTransformList": true,
  "SVGForeignObjectElement": true,
  "SVGRectElement": true,
  "SVGFEDisplacementMapElement": true,
  "SVGAnimateTransformElement": true,
  "SVGAnimatedLength": true,
  "SVGPointList": true,
  "SVGPatternElement": true,
  "SVGPathSegCurvetoCubicSmoothAbs": true,
  "SVGCircleElement": true,
  "SVGSetElement": true,
  "SVGFETileElement": true,
  "SVGMPathElement": true,
  "SVGFEMergeNodeElement": true,
  "SVGPathSegCurvetoQuadraticRel": true,
  "SVGElement": true,
  "SVGGraphicsElement": true,
  "SVGSVGElement": true,
  "SVGGElement": true,
  "SVGGeometryElement": true,
  "SVGPathElement": true,
  "SVGLineElement": true,
  "cat_html": true,
  "HTMLTimeElement": true,
  "HTMLPictureElement": true,
  "HTMLMenuItemElement": true,
  "HTMLFormElement": true,
  "HTMLOptionElement": true,
  "HTMLCanvasElement": true,
  "HTMLTableSectionElement": true,
  "HTMLSelectElement": true,
  "HTMLUListElement": true,
  "HTMLMetaElement": true,
  "HTMLLinkElement": true,
  "HTMLBaseElement": true,
  "HTMLDataListElement": true,
  "HTMLInputElement": true,
  "HTMLMeterElement": true,
  "HTMLSourceElement": true,
  "HTMLTrackElement": true,
  "HTMLTableColElement": true,
  "HTMLFieldSetElement": true,
  "HTMLDirectoryElement": true,
  "HTMLTableCellElement": true,
  "HTMLStyleElement": true,
  "HTMLAudioElement": true,
  "HTMLLegendElement": true,
  "HTMLOListElement": true,
  "HTMLEmbedElement": true,
  "HTMLQuoteElement": true,
  "HTMLMenuElement": true,
  "HTMLHeadElement": true,
  "HTMLUnknownElement": true,
  "HTMLBRElement": true,
  "HTMLProgressElement": true,
  "HTMLMediaElement": true,
  "HTMLFormControlsCollection": true,
  "HTMLCollection": true,
  "HTMLLIElement": true,
  "HTMLDetailsElement": true,
  "HTMLObjectElement": true,
  "HTMLHeadingElement": true,
  "HTMLTableCaptionElement": true,
  "HTMLPreElement": true,
  "HTMLAllCollection": true,
  "HTMLFrameSetElement": true,
  "HTMLFontElement": true,
  "HTMLFrameElement": true,
  "HTMLAnchorElement": true,
  "HTMLOptGroupElement": true,
  "HTMLVideoElement": true,
  "HTMLModElement": true,
  "HTMLBodyElement": true,
  "HTMLTableElement": true,
  "HTMLButtonElement": true,
  "HTMLTableRowElement": true,
  "HTMLAreaElement": true,
  "HTMLDataElement": true,
  "HTMLParamElement": true,
  "HTMLLabelElement": true,
  "HTMLTemplateElement": true,
  "HTMLOptionsCollection": true,
  "HTMLIFrameElement": true,
  "HTMLTitleElement": true,
  "HTMLMapElement": true,
  "HTMLOutputElement": true,
  "HTMLDListElement": true,
  "HTMLParagraphElement": true,
  "HTMLHRElement": true,
  "HTMLImageElement": true,
  "HTMLDocument": true,
  "HTMLElement": true,
  "HTMLScriptElement": true,
  "HTMLHtmlElement": true,
  "HTMLTextAreaElement": true,
  "HTMLDivElement": true,
  "HTMLSpanElement": true,
  "cat_css": true,
  "CSSStyleRule": true,
  "CSSFontFaceRule": true,
  "CSSPrimitiveValue": true,
  "CSSStyleDeclaration": true,
  "CSSStyleSheet": true,
  "CSSPageRule": true,
  "CSSSupportsRule": true,
  "CSSMozDocumentRule": true,
  "CSSKeyframeRule": true,
  "CSSGroupingRule": true,
  "CSS2Properties": true,
  "CSSFontFeatureValuesRule": true,
  "CSSRuleList": true,
  "CSSPseudoElement": true,
  "CSSMediaRule": true,
  "CSSCounterStyleRule": true,
  "CSSImportRule": true,
  "CSSTransition": true,
  "CSSAnimation": true,
  "CSSValue": true,
  "CSSNamespaceRule": true,
  "CSSRule": true,
  "CSS": true,
  "CSSKeyframesRule": true,
  "CSSConditionRule": true,
  "CSSValueList": true,
  "cat_event": true,
  "ondevicemotion": true,
  "ondeviceorientation": true,
  "onabsolutedeviceorientation": true,
  "ondeviceproximity": true,
  "onuserproximity": true,
  "ondevicelight": true,
  "onvrdisplayconnect": true,
  "onvrdisplaydisconnect": true,
  "onvrdisplayactivate": true,
  "onvrdisplaydeactivate": true,
  "onvrdisplaypresentchange": true,
  "onabort": true,
  "onblur": true,
  "onfocus": true,
  "onauxclick": true,
  "oncanplay": true,
  "oncanplaythrough": true,
  "onchange": true,
  "onclick": true,
  "onclose": true,
  "oncontextmenu": true,
  "ondblclick": true,
  "ondrag": true,
  "ondragend": true,
  "ondragenter": true,
  "ondragexit": true,
  "ondragleave": true,
  "ondragover": true,
  "ondragstart": true,
  "ondrop": true,
  "ondurationchange": true,
  "onemptied": true,
  "onended": true,
  "oninput": true,
  "oninvalid": true,
  "onkeydown": true,
  "onkeypress": true,
  "onkeyup": true,
  "onload": true,
  "onloadeddata": true,
  "onloadedmetadata": true,
  "onloadend": true,
  "onloadstart": true,
  "onmousedown": true,
  "onmouseenter": true,
  "onmouseleave": true,
  "onmousemove": true,
  "onmouseout": true,
  "onmouseover": true,
  "onmouseup": true,
  "onwheel": true,
  "onpause": true,
  "onplay": true,
  "onplaying": true,
  "onprogress": true,
  "onratechange": true,
  "onreset": true,
  "onresize": true,
  "onscroll": true,
  "onseeked": true,
  "onseeking": true,
  "onselect": true,
  "onshow": true,
  "onstalled": true,
  "onsubmit": true,
  "onsuspend": true,
  "ontimeupdate": true,
  "onvolumechange": true,
  "onwaiting": true,
  "onselectstart": true,
  "ontoggle": true,
  "onpointercancel": true,
  "onpointerdown": true,
  "onpointerup": true,
  "onpointermove": true,
  "onpointerout": true,
  "onpointerover": true,
  "onpointerenter": true,
  "onpointerleave": true,
  "ongotpointercapture": true,
  "onlostpointercapture": true,
  "onmozfullscreenchange": true,
  "onmozfullscreenerror": true,
  "onanimationcancel": true,
  "onanimationend": true,
  "onanimationiteration": true,
  "onanimationstart": true,
  "ontransitioncancel": true,
  "ontransitionend": true,
  "ontransitionrun": true,
  "ontransitionstart": true,
  "onwebkitanimationend": true,
  "onwebkitanimationiteration": true,
  "onwebkitanimationstart": true,
  "onwebkittransitionend": true,
  "onerror": true,
  "onafterprint": true,
  "onbeforeprint": true,
  "onbeforeunload": true,
  "onhashchange": true,
  "onlanguagechange": true,
  "onmessage": true,
  "onmessageerror": true,
  "onoffline": true,
  "ononline": true,
  "onpagehide": true,
  "onpageshow": true,
  "onpopstate": true,
  "onstorage": true,
  "onunload": true,
  "cat_rtc": true,
  "RTCDTMFSender": true,
  "RTCStatsReport": true,
  "RTCTrackEvent": true,
  "RTCDataChannelEvent": true,
  "RTCPeerConnectionIceEvent": true,
  "RTCCertificate": true,
  "RTCDTMFToneChangeEvent": true,
  "RTCPeerConnection": true,
  "RTCIceCandidate": true,
  "RTCRtpReceiver": true,
  "RTCRtpSender": true,
  "RTCSessionDescription": true,
  "cat_vr": true,
  "VRStageParameters": true,
  "VRFrameData": true,
  "VRDisplay": true,
  "VRDisplayEvent": true,
  "VRFieldOfView": true,
  "VRDisplayCapabilities": true,
  "VREyeParameters": true,
  "VRPose": true,
  "cat_dom": true,
  "DOMStringMap": true,
  "DOMRectReadOnly": true,
  "DOMException": true,
  "DOMRect": true,
  "DOMMatrix": true,
  "DOMMatrixReadOnly": true,
  "DOMPointReadOnly": true,
  "DOMPoint": true,
  "DOMQuad": true,
  "DOMRequest": true,
  "DOMParser": true,
  "DOMTokenList": true,
  "DOMStringList": true,
  "DOMImplementation": true,
  "DOMError": true,
  "DOMRectList": true,
  "DOMCursor": true,
  "cat_idb": true,
  "IDBFileRequest": true,
  "IDBTransaction": true,
  "IDBCursor": true,
  "IDBFileHandle": true,
  "IDBMutableFile": true,
  "IDBKeyRange": true,
  "IDBVersionChangeEvent": true,
  "IDBObjectStore": true,
  "IDBFactory": true,
  "IDBCursorWithValue": true,
  "IDBOpenDBRequest": true,
  "IDBRequest": true,
  "IDBIndex": true,
  "IDBDatabase": true,
  "cat_audio": true,
  "AudioContext": true,
  "AudioBuffer": true,
  "AudioBufferSourceNode": true,
  "Audio": true,
  "MediaElementAudioSourceNode": true,
  "AudioNode": true,
  "BaseAudioContext": true,
  "AudioListener": true,
  "MediaStreamAudioSourceNode": true,
  "OfflineAudioContext": true,
  "AudioDestinationNode": true,
  "AudioParam": true,
  "MediaStreamAudioDestinationNode": true,
  "OfflineAudioCompletionEvent": true,
  "AudioStreamTrack": true,
  "AudioScheduledSourceNode": true,
  "AudioProcessingEvent": true,
  "cat_gamepad": true,
  "GamepadButton": true,
  "GamepadHapticActuator": true,
  "GamepadAxisMoveEvent": true,
  "GamepadPose": true,
  "GamepadEvent": true,
  "Gamepad": true,
  "GamepadButtonEvent": true,
  "cat_media": true,
  "MediaKeys": true,
  "MediaKeyError": true,
  "MediaSource": true,
  "MediaDevices": true,
  "MediaKeyStatusMap": true,
  "MediaStreamTrackEvent": true,
  "MediaRecorder": true,
  "MediaQueryListEvent": true,
  "MediaStream": true,
  "MediaEncryptedEvent": true,
  "MediaStreamTrack": true,
  "MediaError": true,
  "MediaStreamEvent": true,
  "MediaQueryList": true,
  "MediaKeySystemAccess": true,
  "MediaDeviceInfo": true,
  "MediaKeySession": true,
  "MediaList": true,
  "MediaRecorderErrorEvent": true,
  "MediaKeyMessageEvent": true,
  "cat_event2": true,
  "SpeechSynthesisErrorEvent": true,
  "BeforeUnloadEvent": true,
  "CustomEvent": true,
  "PageTransitionEvent": true,
  "PopupBlockedEvent": true,
  "CloseEvent": true,
  "ProgressEvent": true,
  "MutationEvent": true,
  "MessageEvent": true,
  "FocusEvent": true,
  "TrackEvent": true,
  "DeviceMotionEvent": true,
  "TimeEvent": true,
  "PointerEvent": true,
  "UserProximityEvent": true,
  "StorageEvent": true,
  "DragEvent": true,
  "MouseScrollEvent": true,
  "EventSource": true,
  "PopStateEvent": true,
  "DeviceProximityEvent": true,
  "SpeechSynthesisEvent": true,
  "XMLHttpRequestEventTarget": true,
  "ClipboardEvent": true,
  "AnimationPlaybackEvent": true,
  "DeviceLightEvent": true,
  "BlobEvent": true,
  "MouseEvent": true,
  "WheelEvent": true,
  "InputEvent": true,
  "HashChangeEvent": true,
  "DeviceOrientationEvent": true,
  "CompositionEvent": true,
  "KeyEvent": true,
  "ScrollAreaEvent": true,
  "KeyboardEvent": true,
  "TransitionEvent": true,
  "ErrorEvent": true,
  "AnimationEvent": true,
  "FontFaceSetLoadEvent": true,
  "EventTarget": true,
  "captureEvents": true,
  "releaseEvents": true,
  "Event": true,
  "UIEvent": true,
  "cat_other": false,
  "undefined": false,
  "Array": false,
  "Boolean": false,
  "JSON": false,
  "Date": false,
  "Math": false,
  "Number": false,
  "String": false,
  "RegExp": false,
  "Error": false,
  "InternalError": false,
  "EvalError": false,
  "RangeError": false,
  "ReferenceError": false,
  "SyntaxError": false,
  "TypeError": false,
  "URIError": false,
  "ArrayBuffer": true,
  "Int8Array": true,
  "Uint8Array": true,
  "Int16Array": true,
  "Uint16Array": true,
  "Int32Array": true,
  "Uint32Array": true,
  "Float32Array": true,
  "Float64Array": true,
  "Uint8ClampedArray": true,
  "Proxy": true,
  "WeakMap": true,
  "Map": true,
  "Set": true,
  "DataView": false,
  "Symbol": false,
  "SharedArrayBuffer": true,
  "Intl": false,
  "TypedObject": true,
  "Reflect": true,
  "SIMD": true,
  "WeakSet": true,
  "Atomics": true,
  "Promise": true,
  "WebAssembly": true,
  "NaN": false,
  "Infinity": false,
  "isNaN": false,
  "isFinite": false,
  "parseFloat": false,
  "parseInt": false,
  "escape": false,
  "unescape": false,
  "decodeURI": false,
  "encodeURI": false,
  "decodeURIComponent": false,
  "encodeURIComponent": false,
  "uneval": false,
  "BatteryManager": true,
  "CanvasGradient": true,
  "TextDecoder": true,
  "Plugin": true,
  "PushManager": true,
  "ChannelMergerNode": true,
  "PerformanceResourceTiming": true,
  "ServiceWorker": true,
  "TextTrackCueList": true,
  "PerformanceEntry": true,
  "TextTrackList": true,
  "StyleSheet": true,
  "PerformanceMeasure": true,
  "DesktopNotificationCenter": true,
  "Comment": true,
  "DelayNode": true,
  "XPathResult": true,
  "CDATASection": true,
  "MessageChannel": true,
  "BiquadFilterNode": true,
  "SpeechSynthesisUtterance": true,
  "Crypto": true,
  "Navigator": true,
  "FileList": true,
  "URLSearchParams": false,
  "ServiceWorkerContainer": true,
  "ValidityState": true,
  "ProcessingInstruction": true,
  "AbortSignal": true,
  "FontFace": true,
  "FileReader": true,
  "Worker": true,
  "External": true,
  "ImageBitmap": true,
  "TimeRanges": true,
  "Option": true,
  "TextTrack": true,
  "Image": true,
  "AnimationTimeline": true,
  "VideoPlaybackQuality": true,
  "VTTCue": true,
  "Storage": true,
  "XPathExpression": true,
  "CharacterData": false,
  "TextMetrics": true,
  "AnimationEffectReadOnly": true,
  "PerformanceTiming": false,
  "PerformanceMark": true,
  "ImageBitmapRenderingContext": true,
  "Headers": true,
  "Range": false,
  "Rect": true,
  "AnimationEffectTimingReadOnly": true,
  "KeyframeEffect": true,
  "Permissions": true,
  "TextEncoder": true,
  "ImageData": true,
  "SpeechSynthesisVoice": true,
  "StorageManager": true,
  "TextTrackCue": true,
  "WebSocket": true,
  "DocumentType": true,
  "XPathEvaluator": true,
  "PerformanceNavigationTiming": true,
  "IdleDeadline": true,
  "FileSystem": true,
  "FileSystemFileEntry": true,
  "CacheStorage": true,
  "MimeType": true,
  "PannerNode": true,
  "NodeFilter": true,
  "StereoPannerNode": true,
  "console": false,
  "DynamicsCompressorNode": true,
  "PaintRequest": true,
  "RGBColor": true,
  "FontFaceSet": false,
  "PaintRequestList": true,
  "FileSystemEntry": true,
  "XMLDocument": false,
  "SourceBuffer": false,
  "Screen": true,
  "NamedNodeMap": false,
  "History": true,
  "Response": true,
  "AnimationEffectTiming": true,
  "ServiceWorkerRegistration": true,
  "CanvasRenderingContext2D": true,
  "ScriptProcessorNode": true,
  "FileSystemDirectoryReader": true,
  "MimeTypeArray": true,
  "CanvasCaptureMediaStream": true,
  "Directory": true,
  "mozRTCPeerConnection": true,
  "PerformanceObserverEntryList": true,
  "PushSubscriptionOptions": true,
  "Text": false,
  "IntersectionObserverEntry": true,
  "SubtleCrypto": true,
  "Animation": true,
  "DataTransfer": true,
  "TreeWalker": true,
  "XMLHttpRequest": true,
  "LocalMediaStream": true,
  "ConvolverNode": true,
  "WaveShaperNode": true,
  "DataTransferItemList": false,
  "Request": true,
  "SourceBufferList": false,
  "XSLTProcessor": true,
  "XMLHttpRequestUpload": true,
  "SharedWorker": true,
  "Notification": false,
  "DataTransferItem": true,
  "AnalyserNode": true,
  "mozRTCIceCandidate": true,
  "PerformanceObserver": true,
  "OfflineResourceList": true,
  "FileSystemDirectoryEntry": true,
  "DesktopNotification": false,
  "DataChannel": true,
  "IIRFilterNode": true,
  "ChannelSplitterNode": true,
  "File": true,
  "ConstantSourceNode": true,
  "CryptoKey": true,
  "GainNode": true,
  "AbortController": true,
  "Attr": true,
  "SpeechSynthesis": true,
  "PushSubscription": false,
  "XMLStylesheetProcessingInstruction": false,
  "NodeIterator": true,
  "VideoStreamTrack": true,
  "XMLSerializer": true,
  "CaretPosition": true,
  "FormData": true,
  "CanvasPattern": true,
  "mozRTCSessionDescription": true,
  "Path2D": true,
  "PerformanceNavigation": true,
  "URL": false,
  "PluginArray": true,
  "MutationRecord": true,
  "WebKitCSSMatrix": true,
  "PeriodicWave": true,
  "DocumentFragment": true,
  "DocumentTimeline": false,
  "ScreenOrientation": true,
  "BroadcastChannel": true,
  "PermissionStatus": true,
  "IntersectionObserver": true,
  "Blob": true,
  "MessagePort": true,
  "BarProp": true,
  "OscillatorNode": true,
  "Cache": true,
  "RadioNodeList": true,
  "KeyframeEffectReadOnly": true,
  "InstallTrigger": true,
  "Function": false,
  "Object": false,
  "eval": true,
  "Window": false,
  "close": false,
  "stop": false,
  "focus": false,
  "blur": false,
  "open": true,
  "alert": false,
  "confirm": false,
  "prompt": false,
  "print": false,
  "postMessage": true,
  "getSelection": true,
  "getComputedStyle": true,
  "matchMedia": true,
  "moveTo": false,
  "moveBy": false,
  "resizeTo": false,
  "resizeBy": false,
  "scroll": false,
  "scrollTo": false,
  "scrollBy": false,
  "requestAnimationFrame": true,
  "cancelAnimationFrame": true,
  "getDefaultComputedStyle": false,
  "scrollByLines": false,
  "scrollByPages": false,
  "sizeToContent": false,
  "updateCommands": true,
  "find": false,
  "dump": true,
  "setResizable": false,
  "requestIdleCallback": false,
  "cancelIdleCallback": false,
  "btoa": true,
  "atob": true,
  "setTimeout": true,
  "clearTimeout": true,
  "setInterval": true,
  "clearInterval": true,
  "createImageBitmap": true,
  "fetch": true,
  "self": true,
  "name": false,
  "history": true,
  "locationbar": true,
  "menubar": true,
  "personalbar": true,
  "scrollbars": true,
  "statusbar": true,
  "toolbar": true,
  "status": true,
  "closed": true,
  "frames": true,
  "length": false,
  "opener": true,
  "parent": true,
  "frameElement": true,
  "navigator": true,
  "external": true,
  "applicationCache": true,
  "screen": true,
  "innerWidth": true,
  "innerHeight": true,
  "scrollX": true,
  "pageXOffset": true,
  "scrollY": true,
  "pageYOffset": true,
  "screenX": true,
  "screenY": true,
  "outerWidth": true,
  "outerHeight": true,
  "performance": true,
  "mozInnerScreenX": true,
  "mozInnerScreenY": true,
  "devicePixelRatio": true,
  "scrollMaxX": true,
  "scrollMaxY": true,
  "fullScreen": false,
  "mozPaintCount": true,
  "sidebar": false,
  "crypto": true,
  "speechSynthesis": true,
  "localStorage": true,
  "origin": true,
  "isSecureContext": false,
  "indexedDB": true,
  "caches": true,
  "sessionStorage": true,
  "window": false,
  "document": true,
  "location": false,
  "top": true,
  "netscape": true,
  "Node": true,
  "Document": true,
  "Performance": false,
  "startProfiling": true,
  "stopProfiling": true,
  "pauseProfilers": true,
  "resumeProfilers": true,
  "dumpProfile": true,
  "getMaxGCPauseSinceClear": true,
  "clearMaxGCPauseAccumulator": true,
  "Location": true,
  "StyleSheetList": false,
  "Selection": false,
  "Element": true,
  "AnonymousContent": false,
  "MutationObserver": true,
  "NodeList": true,
  "StopIteration": true
};


//************************Comes from HTML file index.html's script test.js****************************

/**
*	If this is true, it evaluates entire scripts instead of returning as soon as it encounters a violation.
*
*	Also, it controls whether or not this part of the code logs to the console.
*
*/
var DEBUG = true;
console.log("DEBUG:" + DEBUG);

function dbg_print(a, b) {
  if (DEBUG == true) {
    //console.log(a,b)
  }
}
function full_evaluate(script) {
  var res = true;
  if (script === undefined || script == "") {
    return [true, "Harmless null script"];
  }

  var ast = acornLoose.parse(script).body[0];

  var flag = false;
  var amtloops = 0;

  var loopkeys = { "for": true, "if": true, "while": true, "switch": true };
  var operators = { "||": true, "&&": true, "=": true, "==": true, "++": true, "--": true, "+=": true, "-=": true, "*": true };
  try {
    var tokens = acorn.tokenizer(script);
  } catch (e) {
    console.warn("Tokenizer could not be initiated (probably invalid code)");
    return [false, "Tokenizer could not be initiated (probably invalid code)"];
  }
  try {
    var toke = tokens.getToken();
  } catch (e) {
    console.warn("couldn't get first token (probably invalid code)");
    console.warn("Continuing evaluation");
  }

  /**
  * Given the end of an identifer token, it tests for bracket suffix notation
  */
  function being_called(end) {
    var i = 0;
    while (script.charAt(end + i).match(/\s/g) !== null) {
      i++;
      if (i >= script.length - 1) {
        return false;
      }
    }
    if (script.charAt(end + i) == "(") {
      return true;
    } else {
      return false;
    }
  }
  /**
  * Given the end of an identifer token, it tests for parentheses
  */
  function is_bsn(end) {
    var i = 0;
    while (script.charAt(end + i).match(/\s/g) !== null) {
      i++;
      if (i >= script.length - 1) {
        return false;
      }
    }
    if (script.charAt(end + i) == "[") {
      return true;
    } else {
      return false;
    }
  }
  var error_count = 0;
  while (toke.type != acorn.tokTypes.eof) {
    if (toke.type.keyword !== undefined) {
      // This type of loop detection ignores functional loop alternatives and ternary operators
      //dbg_print("Keyword:"+toke.type.keyword);
      console.log(toke);
      if (toke.type.keyword == "function") {
        dbg_print("%c NONTRIVIAL: Function declaration.", "color:red");
        if (DEBUG == false) {
          return [false, "NONTRIVIAL: Function declaration."];
        }
      }

      if (loopkeys[toke.type.keyword] !== undefined) {
        amtloops++;
        if (amtloops > 3) {
          dbg_print("%c NONTRIVIAL: Too many loops/conditionals.", "color:red");
          if (DEBUG == false) {
            return [false, "NONTRIVIAL: Too many loops/conditionals."];
          }
        }
      }
    } else if (toke.value !== undefined) {
      var status = fname_data[toke.value];
      if (status === true) { // is the identifier banned?
        dbg_print("%c NONTRIVIAL: nontrivial token: '" + toke.value + "'", "color:red");
        if (DEBUG == false) {
          return [false, "NONTRIVIAL: nontrivial token: '" + toke.value + "'"];
        }
      } else if (status === false) {// is the identifier not banned?
        // Is there bracket suffix notation?
        if (operators[toke.value] === undefined) {
          if (is_bsn(toke.end)) {
            dbg_print("%c NONTRIVIAL: Bracket suffix notation on variable '" + toke.value + "'", "color:red");
            if (DEBUG == false) {
              return [false, "%c NONTRIVIAL: Bracket suffix notation on variable '" + toke.value + "'"];
            }
          }
        }
      } else if (status === undefined) {// is the identifier user defined?
        // Are arguments being passed to a user defined variable?
        if (being_called(toke.end)) {
          dbg_print("%c NONTRIVIAL: User defined variable '" + toke.value + "' called as function", "color:red");
          if (DEBUG == false) {
            return [false, "NONTRIVIAL: User defined variable '" + toke.value + "' called as function"];
          }
        }
        // Is there bracket suffix notation?
        if (operators[toke.value] === undefined) {
          if (is_bsn(toke.end)) {
            dbg_print("%c NONTRIVIAL: Bracket suffix notation on variable '" + toke.value + "'", "color:red");
            if (DEBUG == false) {
              return [false, "NONTRIVIAL: Bracket suffix notation on variable '" + toke.value + "'"];
            }
          }
        }
      } else {
        dbg_print("trivial token:" + toke.value);
      }
    }
    // If not a keyword or an identifier it's some kind of operator, field parenthesis, brackets
    try {
      toke = tokens.getToken();
    } catch (e) {
      dbg_print("Denied script because it cannot be parsed.");
      return [false, "NONTRIVIAL: Cannot be parsed."];
      console.warn("Continuing evaluation");
      error_count++;
    }
  }

  dbg_print("%cAppears to be trivial.", "color:green;");
  return [true, "Script appears to be trivial."];
}

//****************************************************************************************************

window.onload = function() {
  document.getElementById("parse").addEventListener("click", function() {
    var script = document.getElementById("input").value;
    var ast = acornLoose.parse(script).body[0];
    document.getElementById("output").innerHTML = JSON.stringify(ast, null, '\t'); // Indented with tab
    document.getElementById("output").innerHTML = full_evaluate(script) + "\n\n" + document.getElementById("output").innerHTML;
  });
}
